﻿var clientLicenses = {
    datatable: null,
    refreshDataTable: function () {
        clientLicenses.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-createdLicensesTable").a4datatable({
            ajaxAction: a4.getAction("GetLicenses", "General", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "CustomerName", "Title": resources.CustomerName, "Data": "CustomerName", "Class": "v-name" },
                { "Name": "RequestToken", "Title": resources.RequestToken, "Data": "RequestToken" },
                { "Name": "CreatedDate", "Title": resources.CreatedOn, "Data": "CreatedDate" },
                { "Name": "ExpirationDate", "Title": resources.ExpiresOn, "Data": "ExpirationDate", "DefaultValue": resources.NeverExpires }
            ],
            defaultSorting: { Column: "CreatedDate", Ascending: false },
            contextMenuItems: clientLicenses.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "view":
                        clientLicenses.viewItem(row, "false");
                        break;
                    case "copy":
                        clientLicenses.copyItem(row);
                        break;
                    case "delete":
                        clientLicenses.deleteItems(row.Id);
                        break;
                    case "download":
                        clientLicenses.downloadFile(row.Id);
                        break;
                }
            },

            toolBarItems: clientLicenses.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        clientLicenses.deleteItems(ids);
                        break;
                }
            },
        });
    },

    bindEvents: function () {
        $(document).on("click", ".h-createLicense", function () {
            modalDialog.showWindow(a4.getAction("LicenseEditor", "General", "Admin"), 600, 800, { afterClose: function () { clientLicenses.refreshDataTable(); } });
        });
    },

    viewItem: function (item) {
        modalDialog.showWindow(a4.getAction("LicenseEditor", "General", "Admin", { id: item.Id }), 600, 800, { afterClose: function () { clientLicenses.refreshDataTable(); } });
    },

    copyItem: function (item) {
        modalDialog.showWindow(a4.getAction("LicenseEditor", "General", "Admin", { id: item.Id, isCopy: true }), 600, 800, { afterClose: function () { clientLicenses.refreshDataTable(); } });
    },

    downloadFile: function (id) {
        var link = a4.getAction("DownloadLicense", "General", "Admin", { id: id });
        a4.showBusyBox();

        a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetLicenseFile", "General", "Admin", { filename: result.filename });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            }
        );
    },

    deleteItems: function (items) {
        var itemsCount = items.length;

        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteResources, function () {
            a4.callServerMethod(a4.getAction("DeleteClientLicenseItems", "General", "Admin"), { itemIds: items },
                function (result) {
                    clientLicenses.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },

    getContextMenuItems: function () {
        var items = [];
        items.push({ "Action": "view", "Label": resources.View });
        items.push({ "Action": "copy", "Label": resources.Copy });
        items.push({ "Action": "delete", "Label": resources.Delete });
        items.push({ "Action": "download", "Label": resources.Download });
        return items;
    },

    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if ($(".v-createdLicensesTable").length > 0) {
        clientLicenses.initializeDataTable();
        clientLicenses.bindEvents();
    }
});


